/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations.configurator;

import com.aptana.configurations.configurator.IConfigurator;
import com.aptana.configurations.processor.ConfigurationProcessorsRegistry;
import com.aptana.configurations.processor.IConfigurationProcessor;

public class Configurator
implements IConfigurator {
    private String name;
    private String id;
    private String processorId;

    public Configurator(String name, String id, String processorId) {
        this.name = name;
        this.id = id;
        this.processorId = processorId;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public IConfigurationProcessor getProcessor() {
        return ConfigurationProcessorsRegistry.getInstance().getConfigurationProcessor(this.processorId);
    }

    public boolean isEnabled() {
        IConfigurationProcessor processor = this.getProcessor();
        return processor != null && processor.isEnabled();
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 * this.name.hashCode();
        hash = hash * 17 * this.id.hashCode();
        hash = hash * 11 * this.processorId.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == Configurator.class) {
            Configurator other = (Configurator)obj;
            return this.name.equals(other.name) && this.id.equals(other.id) && this.processorId.equals(other.processorId);
        }
        return false;
    }
}

